<?php
class TelegramAPI {
    private $token;
    
    public function __construct($token) {
        $this->token = $token;
    }
    
    public function request($method, $data = []) {
        $url = "https://api.telegram.org/bot{$this->token}/{$method}";
        $ch = curl_init();
        
        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $data,
            CURLOPT_TIMEOUT => 10,
            CURLOPT_SSL_VERIFYPEER => false
        ]);
        
        $response = curl_exec($ch);
        
        if (curl_error($ch)) {
            log_error('CURL Error: ' . curl_error($ch));
            curl_close($ch);
            return false;
        }
        
        curl_close($ch);
        $result = json_decode($response, true);
        
        if (!$result || !$result['ok']) {
            log_error('API Error: ' . ($result['description'] ?? 'Unknown error'));
            return false;
        }
        
        return $result;
    }
    
    public function sendMessage($chat_id, $text, $reply_markup = null, $parse_mode = 'HTML') {
        $data = [
            'chat_id' => $chat_id,
            'text' => $text,
            'parse_mode' => $parse_mode
        ];
        
        if ($reply_markup) {
            $data['reply_markup'] = $reply_markup;
        }
        
        return $this->request('sendMessage', $data);
    }
    
    public function sendKeyboard($chat_id, $text, $keyboard, $resize = true) {
        $reply_markup = [
            'keyboard' => $keyboard,
            'resize_keyboard' => $resize,
            'one_time_keyboard' => false
        ];
        
        return $this->sendMessage($chat_id, $text, json_encode($reply_markup));
    }
    
    public function sendInlineKeyboard($chat_id, $text, $inline_keyboard) {
        $reply_markup = [
            'inline_keyboard' => $inline_keyboard
        ];
        
        return $this->sendMessage($chat_id, $text, json_encode($reply_markup));
    }
    
    public function forwardMessage($to_chat_id, $from_chat_id, $message_id) {
        $data = [
            'chat_id' => $to_chat_id,
            'from_chat_id' => $from_chat_id,
            'message_id' => $message_id
        ];
        
        return $this->request('forwardMessage', $data);
    }
    
    public function deleteMessage($chat_id, $message_id) {
        $data = [
            'chat_id' => $chat_id,
            'message_id' => $message_id
        ];
        
        return $this->request('deleteMessage', $data);
    }
    
    public function getChatMember($chat_id, $user_id) {
        $data = [
            'chat_id' => $chat_id,
            'user_id' => $user_id
        ];
        
        return $this->request('getChatMember', $data);
    }
}
?>