<?php
// bot.php - فایل اصلی

// تنظیمات خطا
error_reporting(E_ALL);
ini_set('display_errors', 1);

// بارگذاری تنظیمات
require_once 'config.php';

// ایجاد پوشه data
if (!file_exists(DATA_PATH)) {
    mkdir(DATA_PATH, 0755, true);
}

// تابع لاگ خطا
function log_error($error) {
    file_put_contents(DATA_PATH . 'errors.log', date('Y-m-d H:i:s') . " - " . $error . PHP_EOL, FILE_APPEND);
}

// بارگذاری کلاس‌ها
require_once 'core/TelegramAPI.php';
require_once 'core/UserManager.php';
require_once 'handlers/MessageHandler.php';

// دریافت آپدیت
$input = file_get_contents('php://input');
$update = json_decode($input, true);

if (!$update) {
    exit('No update received');
}

try {
    // ایجاد شی‌ها
    $telegram = new TelegramAPI(API_KEY);
    $userManager = new UserManager();
    $messageHandler = new MessageHandler($telegram, $userManager);
    
    // پردازش
    if (isset($update['message'])) {
        $messageHandler->handle($update);
    }
    
    if (isset($update['callback_query'])) {
        $messageHandler->handleCallback($update);
    }
    
    echo "OK";
    
} catch (Exception $e) {
    log_error('Bot Error: ' . $e->getMessage());
    echo "Error occurred";
}
?>